import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import Modal from 'react-modal';
import uuidV1 from 'uuid/v1';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import * as authActions from '../actions/authActions';
// import _ from 'lodash';
import './CreateSession.css';

class CreateSession extends Component {
    state = {
      createGroup: false,
      protocolOpen: false,
      // protocol:null
    }

  componentWillMount() {
    Modal.setAppElement('body');
  }


  openSessionModal = () => {
    this.setState({modalIsOpen: true});
    let groupName = null;
    // let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      // protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          return(
          this.setState({
          protocol: group.get('protocol')
          }))
        }
      }
    }

  }

  createSession = () => {
    const sessionId = uuidV1();
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
        }
      }
    }

    this.props.sessionsActions.createSession(sessionId, groupName, protocol);
    this.props.history.push('/sessions/' + sessionId);
  }

  getGroupProtocol = () => {
    let groupName = null;
    let protocol = null;
    if(this.props.currentGroup) {
      groupName = this.props.currentGroup.get('name');
      protocol = this.props.currentGroup.get('protocol');
    }
    if(groupName === null) {
      groupName = (this.props.currentUser)?this.props.currentUser.get('default_group'):null;
      if(groupName != null) {
        const group = this.props.groups.find((g) => g.name === groupName);
        if(group) {
          protocol = group.get('protocol');
          return(
            protocol
          );
        }
      }
    }
  }

  // onChange = (e) => {
  //   const { name, value } = e.target;
  //   const changes = { [name]: value }
  //   this.onChangeThrottle(changes);
  // }

  // onChangeThrottle = _.debounce((changes) => {
  //   this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  // }, 750)

  onGroupChange = (e) => {
    const groupName = e.target.value;

    const group = this.props.groups.find((g) => g.get('name') === groupName);

    this.props.sessionsActions.updateSession(this.props.currentSession, { group: groupName, protocol: group?group.get('protocol'):'' });
  }

  componentWillUpdate = (nextProps, nextState) => {
    if (nextState.createGroup && nextProps.createGroup.get('success')) {
      this.setState({ createGroup: false })
    }
  }

  toggleProtocol = () => {
    this.setState({
      protocolOpen: !this.state.protocolOpen,
      show: false

    });
  }

  closeModal = () => {
    this.setState({modalIsOpen: false});
  }

  handleModalCloseRequest = (e) => {
    // opportunity to validate something and keep the modal open even if it
    // requested to be closed
    e.preventDefault();
    this.setState({modalIsOpen: false});
  }

  render() {

    // if (!this.props.currentSession) {
    //   return (
    //     <form></form>
    //   )
    // }

    return (
      <div>
      {/* <button id="session-button" type="button" className="btn btn-primary btn-lg" onClick={ this.openModal}>Créer une nouvelle session</button> */}
      <a id="session-button" onClick={this.openSessionModal}>Créer une nouvelle session</a>
      <Modal
      className="Modal__Bootstrap modal-dialog bg-primary"
      // closeTimeoutMS={150}
      isOpen={this.state.modalIsOpen}
      onRequestClose={this.handleModalCloseRequest}
      >
        <div className="panel-default">
          <div className="card-body rouded-bottom">
            <form onSubmit={ e => { e.preventDefault() } }>
            <div className="form-group">
                <label className="col-form-label text-secondary">Group</label>
                {/* <p>{this.props.currentSession.group}</p> */}
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary">Titre</label>
                <input className="form-control text-primary"
                  name="title"
                  // defaultValue={ this.props.currentSession.title }
                  onChange={ this.onChange }
                  type="text"
                  placeholder="Entrez un titre"
                />
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary">Description</label>
                <input className="form-control text-primary"
                  type="textarea"
                  name="description"
                  // defaultValue={ this.props.currentSession.description }
                  onChange={ this.onChange }
                  placeholder="Entrez une description"
                />
              </div>
              <div className="form-group">
                <label className="col-form-label text-secondary" onClick={this.toggleProtocol}>Protocole de la prise de note {this.state.protocolOpen?<span className="material-icons protocol-toggle">&#xE313;</span>:<span className="material-icons protocol-toggle">&#xE315;</span>}</label>
                <div className={ `collapse ${this.state.protocolOpen?'in':''}`} >
                  {/* <pre>{JSON.stringify(this.props.currentSession.protocol, null, 2)}</pre> */}
                  <pre>{JSON.stringify(this.getGroupProtocol(), null, 2)}</pre>
                </div>
              </div>
              <div className="text-center">
              <button id="create-button" type="submit" className="btn btn-secondary btn-lg text-primary" onClick={this.createSession}>Commencer</button>
              </div>
            </form>
          </div>
        </div>
      </Modal>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  let group;
  if (props.session && props.session.get('group')) {
    group = state.get('groups').find(group => props.session.get('group') === group.get('name'))
  }

  return {
    currentSession: props.session,
    createGroup: state.get('createGroup'),
    groups: state.get('groups'),
    group
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(CreateSession);
