import rootReducer from '../reducers';
import rootSaga from '../sagas';
import { loadSessions } from '../actions/sessionsActions';
import { createStore, applyMiddleware } from 'redux';
import { routerMiddleware } from 'react-router-redux';
import createSagaMiddleware from 'redux-saga'
import Immutable from 'immutable';

const defaultState = {
  currentSession: null,
  sessions: Immutable.List([]),
  notes: Immutable.List([]),
  isAuthenticated: false,
};

const storeInitialState = Immutable.Map(defaultState);

export default (history, initialState = storeInitialState) => {

  const router = routerMiddleware(history);
  const saga = createSagaMiddleware();

  const store = createStore(rootReducer, initialState, applyMiddleware(router, saga));

  saga.run(rootSaga)

  store.dispatch(loadSessions());

  return store;
};
