import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const createSession = () => {
  return {
    type: types.CREATE_SESSION_ASYNC,
    session: {
      _id: uuidV1(),
      date: new Date(),
      title: '',
      description: '',
    }
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION_ASYNC,
    session: session,
    values: values,
  };
}

export const loadSessions = () => {
  return {
    type: types.LOAD_SESSIONS_ASYNC
  }
}
