import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const createNewSession = () => {
  return {
    type: types.NEW_SESSION,
    session: {
      id: uuidV1(),
      date: new Date(),
      title: '',
      description: '',
    }
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION,
    session: session,
    values: values,
  };
}
