import React, { Component } from 'react';
import { FormGroup, FormControl, Button } from 'react-bootstrap';

class CategoriesTooltip extends Component {

  onButtonClick = (category) => {
    if (typeof this.props.onCategoryClick === 'function') {
      this.props.onCategoryClick(category)
    }
  }

  render() {
    return (
      <div className="categories-tooltip">
        <FormGroup className="buttons">
        {this.props.categories.map((category) =>
          <Button key={ category.name } bsStyle="primary" style={{ backgroundColor: category.color }}
            onClick={this.onButtonClick.bind(this, category)}>{ category.name }</Button>
        )}
        </FormGroup>
        <FormGroup>
          <FormControl />
        </FormGroup>
      </div>
    );
  }
}

export default CategoriesTooltip
