"""
Tests the core api for sessions
"""
import logging

from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
from django.urls import reverse
from django.utils import timezone
from notes import constants
from notes.api.fields import ProtocolField
from rest_framework import serializers, status
from rest_framework.test import APITransactionTestCase

logger = logging.getLogger(__name__)

class ProtocolFieldTests(APITransactionTestCase):

    def setUp(self):
        User = get_user_model()
        self.user1 = User.objects.create_user(
            username='test_user1',
            email='test_user@emial.com',
            password='top_secret'
        )

        self.group = Group(name='group1')
        self.group.save()
        self.group.profile.owner = self.user1
        self.group.profile.save()


    def test_to_representation(self):
        class GroupSerializer(serializers.Serializer):
            protocol = ProtocolField(source='profile.protocol')

        serializer = GroupSerializer(self.group)
        data = serializer.data

        logger.debug("serializer data : %r", repr(data))

        self.assertIn('protocol', data)
        protocol_data = data.get('protocol')

        self.assertIn('id', protocol_data)
        self.assertEqual(self.group.profile.protocol, "%s%s.%s" % (constants.PROTOCOL_URN_PREFIX,protocol_data['id'], protocol_data['version']))

    def test_to_internal_value(self):
        protocol_field = ProtocolField()

        protocol_id, protocol_version = self.group.profile.protocol[len(constants.PROTOCOL_URN_PREFIX):].split('.')

        data = {
            'id': protocol_id,
            'owner': 'group1',
            'title': 'Protocol group group1',
            'description': 'Protocol group group1',
            'version': protocol_version,
            'metacategories': []
        }

        value = protocol_field.to_internal_value(data)

        self.assertEqual(value, self.group.profile.protocol)
