import React, {Component} from 'react';
import { Form, FormGroup, Button } from 'react-bootstrap';
import { Plain } from 'slate';

import PropTypes from 'prop-types';
import SlateEditor from './SlateEditor';

class NoteInput extends Component {

  state = {
    buttonDisabled: false
  }

  onChange = (state) => {
    const text = Plain.serialize(state);
    this.setState({ buttonDisabled: text.length === 0 });
  }

  onAddNoteClick = () => {
    const plain = this.refs.editor.asPlain();
    const raw = this.refs.editor.asRaw();

    this.props.addNote(this.props.session, {
      plain: plain,
      raw: raw
    });

    this.refs.editor.clear();
    setTimeout(() => this.refs.editor.focus(), 250);
  }

  componentDidMount() {
    const text = this.refs.editor.asPlain();
    this.setState({ buttonDisabled: text.length === 0 });
  }

  render() {
    return (
      <Form>
        <FormGroup>
          <div className="editor-wrapper">
            <SlateEditor ref="editor" onChange={this.onChange} />
          </div>
        </FormGroup>
        <Button disabled={this.state.buttonDisabled} bsStyle="primary" type="button" onClick={this.onAddNoteClick}>Add Note</Button>
      </Form>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
