import PropTypes from 'prop-types';
import React, { Component } from 'react';
import { connect } from 'react-redux';
// import logo from './logo.svg';
import { Navbar, Nav, NavItem } from 'react-bootstrap';

class AppNavbar extends Component {

  onClickHome = (e) => {
    e.preventDefault();
    this.props.history.push('/');
  }

  onClickSessions = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  renderLogin() {
    return (
      <NavItem onClick={this.onClickLogin} href="/login">Login</NavItem>
    );
  }

  render() {
    return (
      <Navbar fluid inverse fixedTop>
        <Navbar.Header>
          <Navbar.Brand>
            <a onClick={this.onClickHome} href="/">IRI Notes</a>
          </Navbar.Brand>
          <Navbar.Toggle />
        </Navbar.Header>
        <Navbar.Collapse>
          <Nav>
            <NavItem onClick={this.onClickSessions} href="/sessions">Sessions</NavItem>
          </Nav>
          <Nav pullRight>
            {this.renderLogin()}
          </Nav>
        </Navbar.Collapse>
      </Navbar>
    );
  }
}

AppNavbar.propTypes = {
  isAuthenticated: PropTypes.bool.isRequired
};

function mapStateToProps(state, props) {
  return {
    isAuthenticated: state.get('isAuthenticated')
  };
}

export default connect(mapStateToProps)(AppNavbar);
