import React from 'react';
import PropTypes from 'prop-types';
import {formatTimestamp} from '../utils';

const Note = ({note}) => {
  return (
    <div id={"note-" + note._id} className="note">
      <span className="start">{formatTimestamp(note.startedAt)}</span>
      <span className="finish">{formatTimestamp(note.finishedAt)}</span>
      <div className="note-content" dangerouslySetInnerHTML={{ __html: note.html }} />
      <div className="note-margin-comment">
        <small className="text-muted">{ note.marginComment }</small>
      </div>
    </div>
  );
};

Note.propTypes = {
  note: PropTypes.object.isRequired
};

export default Note;
