import React from 'react';
import { shallow, mount } from 'enzyme';
import NoteInput from '../NoteInput';

const setup = (propOverrides, doMount=false) => {
  const props = Object.assign({
      addNote: jest.fn()
  }, propOverrides);

  const renderFn = doMount?mount:shallow; 
  const wrapper = renderFn(<NoteInput {...props} />);

  return {
    props,
    wrapper,
  }
};

beforeAll(() => {
  window.getSelection = () => {
    return {
      removeAllRanges: () => {}
    };
  };
});

describe('Notes container Component', () => {
  test('render', () => {
    const { wrapper } = setup();
    expect(wrapper.exists()).toBe(true)
  });

  test('click button', () => {
      const { props, wrapper } = setup({}, true);
      wrapper.find('button').simulate('click');
      expect(props.addNote.mock.calls.length).toBe(1);
  });

  test('note value on clickbutton', () => {
      const { props, wrapper } = setup({}, true);
      // This does nothing... must find a way to make it work
      wrapper.find('SlateEditor').simulate('change', {target: {value: 'note text'}});
      wrapper.find('button').simulate('click');
      expect(props.addNote.mock.calls.length).toBe(1);
      // cf. previous comment
      //expect(props.addNote.mock.calls[0]).toEqual(['note text']);
  });

});

