import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Panel, FormGroup, ControlLabel, FormControl } from 'react-bootstrap';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import _ from 'lodash';

class SessionForm extends Component {

  onChange = (e) => {
    const { name, value } = e.target;
    const changes = { [name]: value }
    this.onChangeThrottle(changes);
  }

  onChangeThrottle = _.debounce((changes) => {
    this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  }, 750)

  render() {

    if (!this.props.currentSession) {
      return (
        <form></form>
      )
    }

    return (
      <Panel>
        <form onSubmit={ e => { e.preventDefault() } }>
          <FormGroup>
            <ControlLabel>Title</ControlLabel>
            <FormControl
              name="title"
              defaultValue={ this.props.currentSession.title }
              onChange={ this.onChange }
              type="text"
              placeholder="Enter a title for this session"
              inputRef={ ref => { this.title = ref; } }
            />
          </FormGroup>
          <FormGroup>
            <ControlLabel>Description</ControlLabel>
            <FormControl
              name="description"
              componentClass="textarea"
              defaultValue={ this.props.currentSession.description }
              onChange={ this.onChange }
              placeholder="Enter a description for this session"
              inputRef={ ref => { this.description = ref; } }
            />
          </FormGroup>
        </form>
      </Panel>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentSession: props.session,
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionForm);
