import React from 'react';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import Note from './Note';

const NotesList = ({notes}) => {
  return (
    <div>
      {notes.map((note) => 
        <Note key={note.id} note={note} />  
      )}
    </div>
  );
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;