import React, { Component } from 'react';
import {connect} from 'react-redux';
import {bindActionCreators} from 'redux';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import * as notesActions from '../actions/notes-actions';
import NotesList from './NotesList';
import NoteInput from './NoteInput';

class NotesContainer extends Component {
    render() {
        const { notes } = this.props;
        return (
            <div>
                <NotesList notes={notes} />
                <NoteInput addNote={this.props.actions.addNote} />
            </div>
        );
    }
}

NotesContainer.propTypes = {
    notes: PropTypes.instanceOf(Immutable.List).isRequired,
    actions: PropTypes.object.isRequired
}

function mapStateToProps(state, props) {
  return {
    notes: state.get('notes')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    actions: bindActionCreators(notesActions, dispatch)
  }
}


export default connect(mapStateToProps, mapDispatchToProps)(NotesContainer);