import React, {Component} from 'react';

import PropTypes from 'prop-types';

class NoteInput extends Component {
  constructor(props) {
    super(props);

    this.state = {value: ''};

    this.onAddNoteClick = this.onAddNoteClick.bind(this);
    this.handleChange = this.handleChange.bind(this);
  }

  handleChange(event) {
    this.setState({value : event.target.value});
  }

  onAddNoteClick(event) {
    this.props.addNote(this.state.value);

    this.noteInput.value = "";

    this.noteInput.focus();
  }

  componentDidMount() {
    this.noteInput.focus();
  }

  render() {
    return (
      <div>
        <textarea
          id="noteText"
          onChange={this.handleChange}
          placeholder="note"
          ref={(input) => { this.noteInput = input; }}
        />
        <button onClick={this.onAddNoteClick}>Add Note</button>
      </div>
    );
  }
}

NoteInput.propTypes = {
  addNote: PropTypes.func.isRequired
};

export default NoteInput;
