//import uuidV1 from 'uuid/v1';

import * as types from '../constants/actionTypes';

export const createSession = (sessionId) => {

  //const sessionId = uuidV1();
  const newSession = {
      _id: sessionId,
      ext_id: sessionId,
      date: new Date(),
      title: '',
      description: '',
  };

  return {
    type: types.CREATE_SESSION,
    session: newSession,
    meta: {
      offline: {
        effect: {
          url: "/api/notes/sessions/",
          method: 'POST',
          data: newSession
        },
        commit: { type: types.CREATE_SESSION_ASYNC },
        rollback: { type: 'NoOp'}
      }
    }
  };
}

export const updateSession = (session, values) => {
  return {
    type: types.UPDATE_SESSION,
    session: session,
    values: values,
  };
}

export const loadSessions = () => {
  return {
    type: types.LOAD_SESSIONS
  }
}
