"""irinotes URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.11/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from allauth.account.views import confirm_email as allauthemailconfirmation
from django.conf.urls import include, url
from django.contrib import admin
from django.contrib.auth import views as auth_views
from django.urls import path
from rest_framework.routers import SimpleRouter
from rest_framework_jwt.views import refresh_jwt_token

from notes.api.views.auth import GroupViewSet

authRouter = SimpleRouter()
authRouter.register(r'group', GroupViewSet, base_name='auth_group')

urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^api/notes/', include(('notes.api.urls', 'notes'), namespace='notes')),
    url(r'^api/auth/refresh/', refresh_jwt_token, name='rest_refresh'),
    url(r'^api/auth/', include(('rest_auth.urls', 'rest_auth'), namespace='rest_auth')),
    url(r'^api/auth/', include(authRouter.urls)),
    url(
        '^api/auth/registration/account-confirm-email/(?P<key>[\\s\\d\\w().+-_\',:&]+)/$',
        allauthemailconfirmation,
        name="account_confirm_email"
    ),
    url(
        r'^api/auth/registration/',
        include(
            ('rest_auth.registration.urls', 'rest_auth.registration'),
            namespace='rest_auth_registration')
    ),
    path('auth/reset/<uidb64>/<token>/', auth_views.PasswordResetConfirmView.as_view(), name='password_reset_confirm'),
    path('auth/reset/done/', auth_views.PasswordResetCompleteView.as_view(), name='password_reset_complete'),
    url(r'^auth/', include('rest_framework.urls', namespace='rest_framework')),
]
