from django.contrib import admin
from django.contrib.auth.admin import GroupAdmin as BaseGroupAdmin
from django.contrib.auth.admin import UserAdmin as BaseUserAdmin

from notes.models import GroupProfile, UserProfile


# Define an inline admin descriptor for Employee model
# which acts a bit like a singleton
class UserProfileInline(admin.StackedInline):
    model = UserProfile
    can_delete = False

# Define a new User admin
class UserAdmin(BaseUserAdmin):
    inlines = (UserProfileInline, )


class GroupProfileInline(admin.StackedInline):
    model = GroupProfile
    can_delete = False


class GroupAdmin(BaseGroupAdmin):
    inlines = (GroupProfileInline, )
