"""
Permissions for auth objects
"""
import logging

from rest_framework import permissions
from rest_framework.permissions import BasePermission

logger = logging.getLogger(__name__)


class GroupPermission(BasePermission):
    """
    Pemissions for Groups objects
    """

    def has_permission(self, request, view):
        return request.user and request.user.is_authenticated


    def has_object_permission(self, request, view, obj):
        if request.method not in permissions.SAFE_METHODS:
            return request.user == obj.profile.owner
        return True
