import React from 'react';

import PropTypes from 'prop-types';
import Immutable from 'immutable';

import { ListGroup, ListGroupItem} from 'react-bootstrap';

import Note from './Note';

const NotesList = ({notes}) => {
  return (
    <ListGroup>
      {notes.map((note) => 
        <ListGroupItem key={note.id}><Note note={note} /></ListGroupItem>
      )}
    </ListGroup>
  );
};

NotesList.propTypes = {
  notes: PropTypes.instanceOf(Immutable.List).isRequired
};

export default NotesList;