"""
auth module that defines irinotes' users and group
"""
from django.contrib.auth.models import AbstractUser, Group
from django.db import models
from django.utils.translation import ugettext_lazy as _


class User(AbstractUser):
    class Meta:
        verbose_name = _('User')
        verbose_name_plural = _('Users')

class UserProfile(models.Model):
    user = models.OneToOneField(User, on_delete=models.CASCADE)
    class Meta:
        verbose_name = _('UserProfile')
        verbose_name_plural = _('UserProfiles')


class GroupProfile(models.Model):
    group = models.OneToOneField(Group, unique=True, on_delete=models.CASCADE)
    description = models.TextField(null=True, blank=True)
    class Meta:
        verbose_name = _('GroupProfile')
        verbose_name_plural = _('GroupProfiles')

