"""
Serializers for model core classes
"""
from rest_framework import serializers

from notes.models import Note, Session


class DetailNoteSerializer(serializers.ModelSerializer):
    class Meta:
        model = Note
        fields = (
            'ext_id', 'version', 'created', 'updated',
            'plain', 'html', 'raw',
            'categorization', 'margin_note', 'tc_start', 'tc_end'
        )
        read_only_fields = ('ext_id', 'version', 'created', 'updated')


class ListNoteSerializer(serializers.ModelSerializer):
    class Meta:
        model = Note
        fields = (
            'ext_id', 'tc_start', 'tc_end'
        )
        read_only_fields = ('ext_id', )


class ListSessionSerializer(serializers.ModelSerializer):

    owner = serializers.SlugRelatedField(
        read_only=True, slug_field='username', default=serializers.CurrentUserDefault())

    class Meta:
        model = Session
        fields = (
            'ext_id', 'version', 'created', 'updated',
            'owner', 'title', 'description', 'protocol'
        )
        read_only_fields = ('ext_id', 'version', 'created', 'updated', 'owner')


class DetailSessionSerializer(serializers.ModelSerializer):

    owner = serializers.SlugRelatedField(read_only=True, slug_field='username')
    notes = DetailNoteSerializer(many=True, read_only=True)

    class Meta:
        model = Session
        fields = (
            'ext_id', 'version', 'created', 'updated',
            'owner', 'title', 'description', 'protocol',
            'notes'
        )
        read_only_fields = ('ext_id', 'version', 'created', 'updated', 'owner')
