import Immutable from 'immutable';
import * as types from '../constants/actionTypes';
import SessionRecord from '../store/sessionRecord';

export const sessions = (state = Immutable.List([]), action) => {

  switch (action.type) {

    case types.CREATE_SESSION: {
      return state.push(new SessionRecord(action.session));
    }
    case types.UPDATE_SESSION: {
      const sessionToUpdate = state.find(session => session === action.session);
      const sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      const updatedSession = sessionToUpdate.merge(action.values, {modified: true});
      return state.set(sessionIndex, updatedSession);
    }
    case types.DO_DELETE_SESSION: {
      return state.filter((note) => action.session.get('_id') !== note.session)
    }
    case types.DELETE_SESSION: {
      const sessionIndex = state.indexOf(action.session);
      if (sessionIndex === -1) {
        return state;
      }
      const deletedSession = state.get(sessionIndex);
      return state.set(sessionIndex, deletedSession.merge({deleted:true, modified:true}));
    }
    case types.LOAD_SESSIONS: {
      return action.sessions;
    }
    default:
      return state;
  }
};
