import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import '../App.css';
import * as sessionsActions from '../actions/sessionsActions';
import * as authActions from '../actions/authActions';
import _ from 'lodash';
import './SessionForm.css';

class SessionForm extends Component {

  state = {
    createGroup: false,
    protocolOpen: false,
    titleEditMode: false,
    descriptionEditMode: false,
    enterKeyValue: false,
  }

  onChange = (e) => {
    const { name, value } = e.target;
    const changes = { [name]: value }
    this.onChangeThrottle(changes);
  }

  onChangeThrottle = _.debounce((changes) => {
    this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  }, 750)

  onGroupChange = (e) => {
    const groupName = e.target.value;

    const group = this.props.groups.find((g) => g.get('name') === groupName);

    this.props.sessionsActions.updateSession(this.props.currentSession, { group: groupName, protocol: group?group.get('protocol'):'' });
  }

  componentDidMount() {
    document.addEventListener('mousedown', this.handleClickOutside);
  }

  componentWillUnmount() {
    document.removeEventListener('mousedown', this.handleClickOutside);
  }

  componentWillUpdate = (nextProps, nextState) => {
    if (nextState.createGroup && nextProps.createGroup.get('success')) {
      this.setState({ createGroup: false })
    }
  }

  toggleProtocol = (e) => {
    e.preventDefault();
    this.setState({
      protocolOpen: !this.state.protocolOpen
    });
  }

  toggleOnTitleEditMode = () => {
    this.setState({
      titleEditMode: true,
    });
  }

  toggleOnDescriptionEditMode = () => {
    this.setState({
      descriptionEditMode: true,
    });
  }

  toggleOffTitleEditMode = () => {
    this.setState({
      titleEditMode: false,
    });
  }

  toggleOffDescriptionEditMode = () => {
    this.setState({
      descriptionEditMode: false,
    });
  }

  handleClickOutside = (e) => {
    if (this.title && !this.title.contains(e.target)) {
      this.toggleOffTitleEditMode()
    }

    if (this.desc && !this.desc.contains(e.target)) {
      this.toggleOffDescriptionEditMode()
    }
  }

  saveEdit = (e) => {


    if (e.key === 'Enter') {
      this.setState({enterKeyValue: true})
    }

    if (e.key !== 'Enter') {
      this.setState({enterKeyValue: false})
    }

    if (e.key === 'Enter' && this.state.enterKeyValue === true) {
      this.setState({
        enterKeyValue: false,
        titleEditMode: false,
        descriptionEditMode: false,
      })
    }
  }

  titleEditMode = () => {

    if (this.state.titleEditMode === false) {
      return (
      <div
        onClick={this.toggleOnTitleEditMode}
        className='session-page-title border-0 bg-success text-muted ml-3'
      >
        { this.props.currentSession.title || 'Espace titre' }
      </div>
    );
    }

    if (this.state.titleEditMode === true) {
    return (
    <div className="form-group pr-5">
      <textarea className='session-page-title form-control border-primary bg-secondary text-muted ml-3'
        onKeyDown={ this.saveEdit }
        onChange={ this.onChange }
        type="textarea"
        name="title"
        defaultValue={ this.props.currentSession.title || 'Espace titre' }
        placeholder="Espace titre"
        ref={title => this.title = title}
      >
      </textarea>
    </div>
    );
    }
  }

  descriptionEditMode = () => {

  if (this.state.descriptionEditMode === false) {
    return (
    <div
      onClick={this.toggleOnDescriptionEditMode}
      className="session-page-description border-0 bg-success text-muted ml-3"
    >
      { this.props.currentSession.description || 'Espace description' }
    </div>
  );
  }

  if (this.state.descriptionEditMode === true) {
  return (
    <div className="form-group mt-2 pb-2">
    <textarea className="session-page-description form-control border-primary bg-secondary text-muted ml-3"
      onKeyDown={ this.saveEdit }
      onChange={ this.onChange }
      type="textarea"
      name="description"
      defaultValue={ this.props.currentSession.description || 'Espace description' }
      placeholder="Espace description"
      ref={desc => this.desc = desc}
    >
    </textarea>
  </div>
  );
  }
}

  render() {

    if (!this.props.currentSession) {
      return (
        <form></form>
      )
    }

    return (
        <div className="session-page-panel panel-default sticky-top">
          <div className="session-page-card card-body bg-secondary pr-5">
            <form onSubmit={ e => { e.preventDefault() } }>
              {this.titleEditMode()}
              {this.descriptionEditMode()}
              {/* <div className="form-group">
                <label className="col-form-label">Group</label>
                <p>{this.props.currentSession.group}</p>
              </div> */}
              {/* <div className="form-group">
                <label className="col-form-label" onClick={this.toggleProtocol}>Protocol {this.state.protocolOpen?<span className="material-icons protocol-toggle">&#xE313;</span>:<span className="material-icons protocol-toggle">&#xE315;</span>}</label>
                <div className={ "collapse" + (this.state.protocolOpen?'in':'')} >
                  <pre>{JSON.stringify(this.props.currentSession.protocol, null, 2)}</pre>
                </div>
              </div> */}
            </form>
          </div>
        </div>
    );
  }
}

function mapStateToProps(state, props) {

  let group;
  if (props.session && props.session.get('group')) {
    group = state.get('groups').find(group => props.session.get('group') === group.get('name'))
  }

  return {
    currentSession: props.session,
    createGroup: state.get('createGroup'),
    groups: state.get('groups'),
    group
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionForm);
