"""irinotes URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/1.11/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  url(r'^$', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  url(r'^$', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.conf.urls import url, include
    2. Add a URL to urlpatterns:  url(r'^blog/', include('blog.urls'))
"""
from allauth.account.views import confirm_email as allauthemailconfirmation
from django.conf.urls import include, url
from django.contrib import admin
from rest_framework_jwt.views import refresh_jwt_token

urlpatterns = [
    url(r'^admin/', admin.site.urls),
    url(r'^api/notes/', include('notes.api.urls', namespace='notes')),
    url(r'^api/auth/refresh/', refresh_jwt_token, name='rest_refresh'),
    url(r'^api/auth/', include('rest_auth.urls', namespace='rest_auth')),
    url(
        '^api/auth/registration/account-confirm-email/(?P<key>[\\s\\d\\w().+-_\',:&]+)/$',
        allauthemailconfirmation,
        name="account_confirm_email"
    ),
    url(
        r'^api/auth/registration/',
        include(
            'rest_auth.registration.urls',
            namespace='rest_auth_registration')
    ),
    url(r'^auth/', include('rest_framework.urls', namespace='rest_framework')),
]
