import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Button, FormGroup, ControlLabel, FormControl } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as userActions from '../actions/userActions';

class Settings extends Component {

  updateSettings = () => {
    const username = this.props.currentUser.username;
    const firstname = this.firstname.value;
    const lastname = this.lastname.value;

    this.props.userActions.updateSettings(username, firstname, lastname);
  }

  render() {

    const firstname = this.props.currentUser ? this.props.currentUser.first_name : '';
    const lastname = this.props.currentUser ? this.props.currentUser.last_name : '';

    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <form>
                <FormGroup>
                  <ControlLabel>First name</ControlLabel>
                  <FormControl
                    name="firstname"
                    defaultValue={ firstname }
                    placeholder="John"
                    inputRef={ ref => { this.firstname = ref; } }
                  />
                </FormGroup>
                <FormGroup>
                  <ControlLabel>Last name</ControlLabel>
                  <FormControl
                    name="lastname"
                    defaultValue={ lastname }
                    placeholder="Doe"
                    inputRef={ ref => { this.lastname = ref; } }
                  />
                </FormGroup>
              </form>
              <Button block bsStyle="success" onClick={this.updateSettings}>Save settings</Button>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentUser: state['currentUser'],
  };
}

function mapDispatchToProps(dispatch) {
  return {
    userActions: bindActionCreators(userActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Settings);
