"""
Tests the core models for auth
"""
import logging
from uuid import uuid4

from django.contrib.auth import get_user_model
from django.contrib.auth.models import Group
from django.test import TransactionTestCase

logger = logging.getLogger(__name__)


class AuthModelTests(TransactionTestCase):

    def setUp(self):
        User = get_user_model()
        self.user1 = User.objects.create_user(
            username='test_user1',
            email='test_user@emial.com',
            password='top_secret'
        )
        self.user2 = User.objects.create_user(
            username='test_user2',
            email='test_user@emial.com',
            password='top_secret'
        )
        self.group = Group(name='group1')
        self.group.save()

    def test_create_profile(self):
        self.assertIsNotNone(self.group)
        self.assertIsNotNone(self.group.profile)

