import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { Route, Switch } from 'react-router';
import { ConnectedRouter } from 'react-router-redux';
import createHistory from 'history/createBrowserHistory';

import App from './App';
import SessionList from './components/SessionList';
import Session from './components/Session';
import Login from './components/Login';
import Register from './components/Register';
import Settings from './components/Settings';
import './index.css';
import registerServiceWorker from './registerServiceWorker';
import configureStore from './store/configureStore';
import config from './config';
import AuthenticatedRoute from './misc/AuthenticatedRoute';

const history = createHistory({
    basename: config.basename
});
const store = configureStore(history);

ReactDOM.render(
  <Provider store={store}>
    <ConnectedRouter history={history}>
      <Switch>
        <Route exact path="/sessions/:id" component={Session} />
        <Route exact path="/sessions" component={SessionList} />
        <Route exact path="/register" component={Register} />
        <Route exact path="/login" component={Login} />
        <AuthenticatedRoute exact path="/settings" component={Settings} store={store} />
        <Route exact path="/" component={App} />
      </Switch>
    </ConnectedRouter>
  </Provider>,
  document.getElementById('root')
);
registerServiceWorker();
