import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, ListGroup, ListGroupItem, Button } from 'react-bootstrap';
import moment from 'moment';
import '../App.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';
import uuidV1 from 'uuid/v1';

class SessionList extends Component {

  createSession = () => {
    const sessionId = uuidV1();
    this.props.sessionsActions.createSession(sessionId);
    this.props.history.push('/sessions/' + sessionId);
  }

  onClickDelete(session, e) {
    e.preventDefault();
    e.stopPropagation();

    this.props.sessionsActions.deleteSession(session);
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <ListGroup>
                {this.props.sessions.map((session) =>
                  <ListGroupItem
                    key={session.get('_id')}
                    onClick={() => this.props.history.push('/sessions/' + session.get('_id'))}>
                    {session.title || 'No title'} {session.get('_id')} {moment(session.get('date')).format('DD/MM/YYYY')}
                    <a className="pull-right" onClick={ this.onClickDelete.bind(this, session) }>
                      <span className="material-icons">delete</span>
                    </a>
                  </ListGroupItem>
                )}
              </ListGroup>
              <Button bsStyle="success" onClick={this.createSession}>Create new session</Button>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    sessions: state['sessions']
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(SessionList);
