// cf. http://redux.js.org/docs/recipes/WritingTests.html

import * as actions from '../notesActions'
import * as types from '../../constants/actionTypes'

describe('actions', () => {

  it('should create an action to add a note', () => {
    const text = 'hello world';
    const dateNote = Date.now();
    const data = {
      raw: {
        document: {
          nodes: [
            {
              object: 'block',
              type: 'paragraph',
              nodes: [
                {
                  object: 'text',
                  leaves: [
                    {
                      text: text,
                    },
                  ],
                },
              ],
            },
          ],
        },
      },
      plain: text,
      html: text,
      startedAt: dateNote,
      finishedAt: dateNote + 10000,
      categories: [],
      marginComment: 'empty',
    }
    const session = { _id: 'abcd123' }
    const expectedAction = {
      type: types.ADD_NOTE,
      note: {
        _id: expect.stringMatching(/[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}/),
        session: session._id
      }
    }

    const receivedAction = actions.addNote(session, data);
    expect(receivedAction).toMatchObject(expectedAction);

  })
})
