import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import NoteInput from './NoteInput';
import NotesList from './NotesList';
import * as sessionsActions from '../actions/sessionsActions';
import * as notesActions from '../actions/notesActions';
import _ from 'lodash';

class Session extends Component {

  onChange = (e) => {
    const { name, value } = e.target;
    const changes = { [name]: value }
    this.onChangeThrottle(changes);
  }

  onChangeThrottle = _.debounce((changes) => {
    this.props.sessionsActions.updateSession(this.props.currentSession, changes);
  }, 750)

  componentDidMount = () => {
    this.props.notesActions.loadNotesBySession({ _id: this.props.match.params.id });
  }

  renderForm() {

    if (!this.props.currentSession) {
      return (
        <form></form>
      )
    }

    return (
      <form>
        <FormGroup>
          <ControlLabel>Title</ControlLabel>
          <FormControl
            name="title"
            defaultValue={ this.props.currentSession.title }
            onChange={ this.onChange }
            type="text"
            placeholder="Enter a title for this session"
            inputRef={ ref => { this.title = ref; } }
          />
        </FormGroup>
        <FormGroup>
          <ControlLabel>Description</ControlLabel>
          <FormControl
            name="description"
            componentClass="textarea"
            defaultValue={ this.props.currentSession.description }
            onChange={ this.onChange }
            placeholder="Enter a description for this session"
            inputRef={ ref => { this.description = ref; } }
          />
        </FormGroup>
      </form>
    );
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={3}>
              <Panel>
                { this.renderForm() }
              </Panel>
            </Col>
            <Col md={9}>
              <NotesList notes={this.props.notes} />
            </Col>
          </Row>
        </Grid>
        <section className="editor-fixed">
          <Grid fluid>
            <Row>
              <Col md={9} mdOffset={3}>
                <NoteInput session={this.props.currentSession} addNote={this.props.notesActions.addNote} />
              </Col>
            </Row>
          </Grid>
        </section>
      </div>
    );
  }
}

function mapStateToProps(state, props) {

  const sessionId = props.match.params.id;

  const sessions = state.get('sessions');
  const notes = state.get('notes');
  const currentSession = sessions.find(session => session._id === sessionId);

  return {
    currentSession,
    sessions,
    notes,
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch),
    notesActions: bindActionCreators(notesActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Session);
