"""
models for metacategories and protocol
"""
from colorful.fields import RGBColorField
from django.db import models
from django.utils.translation import ugettext_lazy as _

from .base import Model
from .auth import GroupProfile


class Protocol(Model):
    title = models.CharField(max_length=255, verbose_name=_('Protocol|title'))
    # group_profile = models.OneToOneField(
    #     GroupProfile, on_delete=models.CASCADE)

    class Meta:
        verbose_name = _('Protocol')
        verbose_name_plural = _('Protocols')


class Category(models.Model):
    title = models.CharField(max_length=255, verbose_name=_('Category|title'))
    color = RGBColorField(verbose_name=_('Category|color'))
    need_comment = models.BooleanField(
        default=False,
        verbose_name=_('Category|need_comment')
    )
    description = models.TextField(
        null=True,
        blank=True,
        verbose_name=_('Category|description')
    )
    protocol = models.ForeignKey(
        Protocol,
        verbose_name=_('Category|protocol'),
        related_name='categories',
        on_delete=models.CASCADE
    )

    class Meta:
        verbose_name = _('Category')
        verbose_name_plural = _('Categories')
