import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button, Alert, HelpBlock } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';
import { getOnline, getCreateGroup } from '../selectors/authSelectors';

class CreateGroup extends Component {

  state = {
    name: '',
    description: ''
  }

  createGroup = () => {

    const { name, description } = this.state;

    if(name && name.trim() !== "") {
      this.props.authActions.createGroup(name, description);
    }
  }

  submit = (e) => {
    e.preventDefault();

    this.createGroup();
  }

  handleInputChange = (e) => {
    const target = e.target;
    const value = target.value;
    const name = target.name;

    this.setState({
      [name]: value
    });
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && fieldname in errorMessages) {
      return errorMessages[fieldname].map((message, key) =>
        <HelpBlock key={ key }>{ message }</HelpBlock>
      );
    }
  }

  renderNonFieldErrors(errorMessages) {
    if (errorMessages && 'non_field_errors' in errorMessages) {
      const errors = errorMessages['non_field_errors'];
      return (
        <Alert bsStyle="danger">
        { errors.map((message, key) =>
          <p key={ key }>{ message }</p>
        ) }
        </Alert>
      )
    }
  }

  cancel = (e) => {
    e.preventDefault();
    this.props.history.push('/sessions');
  }


  render() {

    const panelHeader = (
      <h4 className="text-uppercase text-center">New Group</h4>
    )

    const errorMessages = this.props.createGroup.getIn(['errorMessages', 'data']);
    const okDisabled = (!this.state.name || this.state.name.trim() === "");

    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <Panel header={ panelHeader } className="panel-login">
                <form onSubmit={this.submit}>
                  <FormGroup validationState={ errorMessages && ('name' in errorMessages) ? 'error' : null }>
                    <ControlLabel>Nom</ControlLabel>
                    <FormControl componentClass="input" type="text" onChange={this.handleInputChange} name="name" placeholder="Group name..."/>
                     { this.renderErrorMessage(errorMessages, 'name') }
                  </FormGroup>
                  <FormGroup validationState={ errorMessages && ('description' in errorMessages) ? 'error' : null }>
                    <ControlLabel>Password</ControlLabel>
                    <FormControl componentClass="textarea" onChange={this.handleInputChange} name="description" placeholder="Description..."/>
                     { this.renderErrorMessage(errorMessages, 'description') }
                  </FormGroup>
                  { this.renderNonFieldErrors(errorMessages) }
                  <Row>
                  <Col md={6}><Button type="submit" block bsStyle="primary" disabled={okDisabled}>Ok</Button></Col>
                  <Col md={6}><Button block bsStyle="default" onClick={this.cancel}>Cancel</Button></Col>
                  </Row>
                </form>
              </Panel>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    createGroup: getCreateGroup(state),
    online: getOnline(state),
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch),
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(CreateGroup);
