import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button, Alert, HelpBlock } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Register extends Component {

  register = () => {
    const username = this.username.value;
    const email = this.email.value;
    const password1 = this.password1.value;
    const password2 = this.password2.value;

    this.props.authActions.registerSubmit(username, email, password1, password2);
  }

  onClickLogin = (e) => {
    e.preventDefault();
    this.props.history.push('/login');
  }

  renderError() {
    return (
      <Alert bsStyle="danger">Bad credentials</Alert>
    )
  }

  renderErrorMessage(errorMessages, fieldname) {
    if (errorMessages && errorMessages.has(fieldname)) {
      return errorMessages.get(fieldname).map((message, key) =>
        <HelpBlock key={ key }>{ message }</HelpBlock>
      );
    }
  }

  render() {

    const panelHeader = (
      <h4 className="text-uppercase text-center">Register</h4>
    )

    const errorMessages = this.props.register.get('errorMessages');

    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <Panel header={ panelHeader } className="panel-login">
                <form>
                  <FormGroup validationState={ errorMessages && errorMessages.has('username') ? 'error' : null }>
                    <ControlLabel>Username</ControlLabel>
                    <FormControl componentClass="input" type="text" inputRef={ref => { this.username = ref; }} />
                    { this.renderErrorMessage(errorMessages, 'username') }
                  </FormGroup>
                  <FormGroup validationState={ errorMessages && errorMessages.has('email') ? 'error' : null }>
                    <ControlLabel>Email</ControlLabel>
                    <FormControl componentClass="input" type="email" inputRef={ref => { this.email = ref; }} />
                    { this.renderErrorMessage(errorMessages, 'email') }
                  </FormGroup>
                  <FormGroup validationState={ errorMessages && errorMessages.has('password1') ? 'error' : null }>
                    <ControlLabel>Password</ControlLabel>
                    <FormControl componentClass="input" type="password" inputRef={ref => { this.password1 = ref; }} />
                    { this.renderErrorMessage(errorMessages, 'password1') }
                  </FormGroup>
                  <FormGroup validationState={ errorMessages && errorMessages.has('password2') ? 'error' : null }>
                    <ControlLabel>Confirm password</ControlLabel>
                    <FormControl componentClass="input" type="password" inputRef={ref => { this.password2 = ref; }} />
                    { this.renderErrorMessage(errorMessages, 'password2') }
                  </FormGroup>
                  <Button block bsStyle="primary" onClick={this.register}>Register</Button>
                </form>
              </Panel>
              <p className="text-center">
                <a className="text-muted" href="/login" onClick={ this.onClickLogin }>Already registered? Sign in.</a>
              </p>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    register: state['register']
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Register);
