import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, Panel, FormGroup, ControlLabel, FormControl, Button, Alert } from 'react-bootstrap';
import '../App.css';
import Navbar from './Navbar';
import * as authActions from '../actions/authActions';

class Login extends Component {

  login = () => {
    const username = this.username.value;
    const password = this.password.value;

    this.props.authActions.loginSubmit(username, password);
  }

  onClickRegister = (e) => {
    e.preventDefault();
    this.props.history.push('/register');
  }

  renderError() {
    return (
      <Alert bsStyle="danger">Bad credentials</Alert>
    )
  }

  render() {

    const panelHeader = (
      <h4 className="text-uppercase text-center">Login</h4>
    )

    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <Panel header={ panelHeader } className="panel-login">
                <form>
                  <FormGroup>
                    <ControlLabel>Username</ControlLabel>
                    <FormControl componentClass="input" type="text" inputRef={ref => { this.username = ref; }} />
                  </FormGroup>
                  <FormGroup>
                    <ControlLabel>Password</ControlLabel>
                    <FormControl componentClass="input" type="password" inputRef={ref => { this.password = ref; }} />
                  </FormGroup>
                  { this.props.login.error && this.renderError() }
                  <Button block bsStyle="primary" onClick={this.login}>Login</Button>
                </form>
              </Panel>
              <p className="text-center">
                <a className="text-muted" href="/register" onClick={ this.onClickRegister }>Not registered yet? Create an account.</a>
              </p>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentUser: state['currentUser'],
    login: state['login']
  };
}

function mapDispatchToProps(dispatch) {
  return {
    authActions: bindActionCreators(authActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Login);
