import React, { Component } from 'react';
import { connect } from 'react-redux';
import { bindActionCreators } from 'redux';
import { Grid, Row, Col, ListGroup, ListGroupItem, Button } from 'react-bootstrap';
import moment from 'moment';
import '../App.css';
import Navbar from './Navbar';
import * as sessionsActions from '../actions/sessionsActions';

class Sessions extends Component {

  createSession = () => {
    this.props.sessionsActions.createSession();
  }

  componentDidUpdate = () => {
    if (this.props.currentSession) {
      this.props.history.push('/sessions/' + this.props.currentSession._id)
    }
  }

  render() {
    return (
      <div>
        <Navbar history={this.props.history} />
        <Grid fluid>
          <Row>
            <Col md={6} mdOffset={3}>
              <ListGroup>
                {this.props.sessions.map((session) =>
                  <ListGroupItem
                    key={session._id}
                    onClick={() => this.props.history.push('/sessions/' + session._id)}>
                    {session.title || 'No title'} {session._id} {moment(session.date).format('DD/MM/YYYY')}
                  </ListGroupItem>
                )}
              </ListGroup>
              <Button bsStyle="success" onClick={this.createSession}>Create new session</Button>
            </Col>
          </Row>
        </Grid>
      </div>
    );
  }
}

function mapStateToProps(state, props) {
  return {
    currentSession: state.get('currentSession'),
    sessions: state.get('sessions')
  };
}

function mapDispatchToProps(dispatch) {
  return {
    sessionsActions: bindActionCreators(sessionsActions, dispatch)
  }
}

export default connect(mapStateToProps, mapDispatchToProps)(Sessions);
