import logging

from django.contrib.auth.models import Group
from rest_framework import viewsets

from ..serializers.auth import (GroupSerializer, WriteGroupSerializer, DetailGroupSerializer)
from ..permissions.auth import (GroupPermission, )

logger = logging.getLogger(__name__)


class GroupViewSet(viewsets.ModelViewSet):
    serializer_class = GroupSerializer
    permission_classes = (GroupPermission, )
    lookup_field = 'name'

    def get_queryset(self):
        return Group.objects.all().order_by('name')

    serializers = {
        'create': WriteGroupSerializer,
        'update': WriteGroupSerializer,
        'retrieve': DetailGroupSerializer,
    }

    def get_serializer_class(self):
        return self.serializers.get(self.action, GroupSerializer)
