import {
  getOnline,
  getToken,
  isAuthenticated,
  getCurrentUser,
  getClientId,
  getCurrentGroupName,
  getCreateGroup,
  getAutoSubmit,
  getGroups,
  getCurrentGroup,
  getLoginErrorMessages
} from '../authSelectors';

import asyncRequest from '../../constants/asyncRequest';


describe('Auth selector test', () => {

  test('getOnline', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
    };

    expect(getOnline(inputState)).toBe(false);
  })

  test('getToken', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
      },
    };

    expect(getToken(inputState)).toBe('abc');
  })

  test('isAuthenticated', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
      },
    };

    expect(isAuthenticated(inputState)).toBe(false);
  })


  test('getCurrentUser', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        currentUser: 'admin',
      },
    };

    expect(getCurrentUser(inputState)).toBe('admin');
  })

  test('getClientId', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
      },
    };

    expect(getClientId(inputState)).toBe('12345');
  })

  test('getCurrentGroupName', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'adminGroup'
      },
    };

    expect(getCurrentGroupName(inputState)).toBe('adminGroup');
  })

  test('getCurrentGroupName', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'adminGroup'
      },
    };

    expect(getCurrentGroupName(inputState)).toBe('adminGroup');
  })

  test('getCreateGroup', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'adminGroup'
      },
      createGroup: asyncRequest
    };

    expect(getCreateGroup(inputState)).toBe(asyncRequest);
  })

  test('getAutoSubmit', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'adminGroup'
      },
      autoSubmit: false
    };

    expect(getAutoSubmit(inputState)).toBe(false);
  })

  test('getGroups', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'adminGroup'
      },
      autoSubmit: false,
      groups: [
        { name: 'group1'},
        { name: 'group2'},
      ]
    };

    expect(getGroups(inputState)).toEqual([
      { name: 'group1'},
      { name: 'group2'},
    ]);
  })

  test('getCurrentGroupOk', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'group1'
      },
      autoSubmit: false,
      groups: [
        { name: 'group1'},
        { name: 'group2'},
      ]
    };

    expect(getCurrentGroup(inputState)).toEqual({ name: 'group1'});
  })


  test('getCurrentGroupOther', ()  => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'group2'
      },
      autoSubmit: false,
      groups: [
        { name: 'group1'},
        { name: 'group2'},
        { name: 'group3'},
        { name: 'group4'},
      ]
    };

    expect(getCurrentGroup(inputState)).toEqual({ name: 'group2'});
  })


  test('getCurrentGroupUndefined', () => {
    const inputState = {
      status: {
        isSynchronizing: false,
        online: false
      },
      authStatus: {
        token: 'abc',
        isAuthenticated: false,
        clientId: '12345',
        currentUser: 'admin',
        currentGroup: 'unknownGroup'
      },
      autoSubmit: false,
      groups: [
        { name: 'group1'},
        { name: 'group2'},
      ]
    };

    expect(getCurrentGroup(inputState)).toEqual(undefined);
  })

  test('getLoginErrorMessages', () => {
    const inputState = {
      login: {
        loading: false,
        success: false,
        error: false,
        errorMessages: {}
      }
    }

    expect(getLoginErrorMessages(inputState)).toEqual({});
  })

  test('getLoginErrorMessagesUndefined', () => {
    const inputState = {
    }

    expect(getLoginErrorMessages(inputState)).toEqual(undefined);
  })

  test('getLoginErrorMessagesUndefinedPath', () => {
    const inputState = {
      login: {
      }
    }
    expect(getLoginErrorMessages(inputState)).toEqual(undefined);
  })


})
