# How to start?

1. Make sure PIP is installed then install Django and others dependencies with 

```
pip install -r requirements.txt

```

2. Move to src/iconolab/static/js/iconolab-bundle to install js dependencies.
Make sure your have installed nodejs then run the command bellow

```
npm install

```
3. To recreate the bundle file that lives in dist/

```
npm run build

```

4. To add a new js module, you can add it to the js/components folder and then run

```
npm start
```

## ICONOLAB ##

### 1. Configuration and setup

### virtualenv

- Install pip
- Create a virtualenv for the project (using virtualenvwrapper is a good idea if possible). Python version is 3.5.1
- Run

	pip install -r requirements.txt


### node.js

- Make sure nodejs is installed
- cd into iconolab/src/iconolab/static/iconolab/js and run
	
	npm install

- To recreate the bundle file that lives in dist/

	npm build

- To add a new js module, you can add it to the js/components folder and then run
	
	npm start

### Django project setup

- Copy iconolab/src/settings/dev.py.tmpl into iconolab/src/settings/dev.py, adapt content to configuration
- cd into iconolab/src folder and run

    python manage.py migrate

to create database tables

- Run

    python manage.py createsuperuser
    
to create an admin user

- Run

    python manage.py loaddata dev_initial_data
    
to load the provided data fixture. This fixture will create at least one of each object used in the app. Details on the fixture data below.


### 2. Development server

- cd into the iconolab/src folder and run

	python manage.py runserver
	
By default, the app is accessible through http://127.0.0.1:8000/home

### 3. Importing data from CSV

Make sure to have the following in the same folder:

* All the images to import. The image names must match their respective item inventory number.
* A csv file that contains the metadata for the items you will import
* A json fixture file for initializing the collection in the database. (Optional if you want to import images in an existing collection)
* A json fixture file for the metacategories that will be linked to the collection.

The following django manage.py command is used to import collection data and images:

	python manage.py importimages <:export-csv-path> --encoding <:encoding> --collection-fixture <:collection_fixture_NAME> (OR --collection-id <:collection_id> --metacategories_fixture <:metacategories_fixture_NAME> 
	
Notes: 
* The export csv path will be used to find everything else (images and fixtures files). 
* If the csv file is not encoded in utf-8, you MUST provide --encoding so the csv file can be read
* You MUST provide either --collection-fixture or --collection-id, else the command doesn't know to which collection the objects will belong to.
* The command will first parse the csv, then create the objects in the database (Item and ItemMetadata), then move the images to the settings.MEDIA_ROOT+/uploads/ folder after converting them to JPEG, then create the database objects for the images. The command will ignore any csv row that lacks an image or any csv row that already has a database entry for the collection (INV number is used to test if a database entry exists).

