# -*- coding: utf-8 -*-
# Generated by Django 1.10.5 on 2017-05-24 11:07
from __future__ import unicode_literals

from django.db import migrations

AWAITING = 0
ACCEPTED = 1
REJECTED = 2
STUDIED = 3


# This is a bit of code repetition because you can not access object methods
def set_tags_stats(obj, apps):
    Tag = apps.get_model('iconolab', 'Tag')
    obj.tag_count = Tag.objects.filter(
        tagginginfo__revision=obj.annotation.current_revision).distinct().count()
    obj.relevant_tags_count = relevant_tags_count_calc(obj, apps)
    obj.accurate_tags_count = accurate_tags_count_calc(obj, apps)

def relevant_tags_count_calc(obj, apps):
    TaggingInfo = apps.get_model('iconolab', 'TaggingInfo')
    return TaggingInfo.objects.filter(revision=obj.annotation.current_revision, relevancy__gte=3).distinct().count()

def accurate_tags_count_calc(obj, apps):
    TaggingInfo = apps.get_model('iconolab', 'TaggingInfo')
    return TaggingInfo.objects.filter(revision=obj.annotation.current_revision, accuracy__gte=3).distinct().count()

def contributors(obj, apps):
    User = apps.get_model('auth', 'User')
    user_ids_list = obj.annotation.revisions.filter(
        state__in=[ACCEPTED, STUDIED]
    ).values_list("author__id", flat=True)
    return User.objects.filter(id__in=user_ids_list).distinct()


def update_stats(obj, apps):
    # views_count - Can't do much about views count
    # submitted_revisions_count
    annotation_revisions = obj.annotation.revisions
    obj.submitted_revisions_count = annotation_revisions.count()
    # aawaiting_revisions_count
    obj.awaiting_revisions_count = annotation_revisions.filter(
        state=AWAITING).count()
    # accepted_revisions_count
    obj.accepted_revisions_count = annotation_revisions.filter(state=ACCEPTED).count(
    ) + annotation_revisions.filter(state=STUDIED).count()
    # comment_count
    Comment = apps.get_model('django_comments', 'Comment')
    obj.comments_count = Comment.objects.filter(
        object_pk=obj.annotation.pk,
    ).count()
    # contributors
    contrib_list = contributors(obj,apps)
    obj.contributors.set(contrib_list)
    obj.contributors_count = len(contrib_list)
    # tag_count

    IconolabComment = apps.get_model('iconolab', 'IconolabComment')
    annotation_comments_with_metacategories = IconolabComment.objects.filter(
        content_type__app_label="iconolab",
        content_type__model="annotation",
        object_pk=obj.annotation.id,
        metacategories__collection=obj.annotation.image.item.collection
    )
    MetaCategoriesCountInfo = apps.get_model('iconolab', 'MetaCategoriesCountInfo')
    m2m_objects = MetaCategoriesCountInfo.objects.filter(
        annotation_stats_obj=obj)
    for obj1 in m2m_objects.all():
        obj1.count = 0
        obj1.save()
    for comment in annotation_comments_with_metacategories.all():
        for metacategory in comment.metacategories.all():
            if metacategory not in obj.metacategories.all():
                MetaCategoriesCountInfo.objects.create(
                    annotation_stats_obj=obj, metacategory=metacategory, count=1)
            else:
                m2m_object = MetaCategoriesCountInfo.objects.filter(
                    annotation_stats_obj=obj, metacategory=metacategory).first()
                m2m_object.count += 1
                m2m_object.save()
    set_tags_stats(obj, apps)
    obj.save()




def update_annotation_stats_for_accurate_relevant_tag_count(apps, schema_editor):
    AnnotationStats = apps.get_model('iconolab', 'AnnotationStats')
    for ann_stats_obj in AnnotationStats.objects.all():
        update_stats(ann_stats_obj, apps)


class Migration(migrations.Migration):

    dependencies = [
        ('iconolab', '0025_annotationstats_contributors'),
        ('auth', '0008_alter_user_username_max_length'),
        ('django_comments', '0002_update_user_email_field_length')
    ]

    operations = [
        migrations.RunPython(update_annotation_stats_for_accurate_relevant_tag_count),
    ]
