from django.apps import apps
from django.db.models.signals import post_save
from django.dispatch import Signal, receiver
from notifications.signals import notify
from django_comments.signals import comment_was_posted

# Signal sent during method Annotation.validate_existing_revision to update stats
revision_accepted = Signal(providing_args=['instance'])
revision_created = Signal(providing_args=['instance'])


def increment_stats_on_new_revision(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        # Annotation stats
        annotation = instance.annotation
        annotation.stats.submitted_revisions_count += 1
        if instance.state in [AnnotationRevision.ACCEPTED, AnnotationRevision.STUDIED]:
            annotation.stats.accepted_revisions_count += 1
        if instance.state in [AnnotationRevision.AWAITING]:
            annotation.stats.awaiting_revisions_count += 1
        annotation.stats.set_tags_stats()
        annotation.stats.save()
        # Image stats
        image = instance.annotation.image
        image.stats.submitted_revisions_count += 1
        image.stats.set_tags_stats()
        image.stats.save()
        
    
def increment_stats_on_new_comments(sender, instance, created, **kwargs):
    from iconolab.models import IconolabComment
    if created and sender == IconolabComment:
        model = apps.get_model(instance.content_type.app_label,instance.content_type.model)
        object_pk = instance.object_pk
        annotation = model._default_manager.get(pk=object_pk)
        annotation.stats.comments_count +=1
        annotation.stats.save()
        annotation.image.stats.comments_count +=1
        annotation.image.stats.save()


def increment_accepted_revisions(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        annotation = instance.annotation
        annotation.stats.accepted_revisions_count += 1
        annotation.stats.save()

def increment_annotations_count(sender, instance, created, **kwargs):
    from iconolab.models import Annotation
    if created and sender == Annotation:
        image = instance.image
        image.stats.annotations_count += 1
        image.stats.submitted_revisions_count += 1
        image.stats.set_tags_stats()
        image.stats.save()


def notify_users_on_new_comment(sender, comment, **kwargs):
    from iconolab.models import IconolabComment, Annotation, MetaCategory
    if sender == IconolabComment and instance.content_type.app_label == 'iconolab' and instance.content_type.model == 'annotation':
        comment_annotation = Annotation.objects.get(id=instance.object_pk)
        # Notifying new user comment
        if instance.user != comment_annotation.author:
            notify.send(instance.user, recipient=comment_annotation.author, verb='a écrit un commentaire sur votre annotation', action_object=instance, target=comment_annotation)
        print(instance.parent_id)
        print(instance.id)
        if instance.level > 0:
            parent_comment = IconolabComment.objects.get(id=instance.parent_id)
            notify.send(instance.user, recipient=parent_comment.user, verb='a répondu à votre commentaire', action_object=instance, target=comment_annotation)
        for metacategory in instance.metacategories.all():
            if metacategory.triggers_notifications == MetaCategory.COMMENTERS:
                for commenter in comment_annotation.stats.commenters.exclude(id=instance.user.id).all():
                    notify.send(instance.user, recipient=commenter, verb='a fait un appel à contribution', action_object=instance, target=comment_annotation)
            elif metacategory.triggers_notifications == MetaCategory.CONTRIBUTORS:
                for contributor in comment_annotation.stats.contributors.exclude(id=instance.user.id).all():
                    notify.send(instance.user, recipient=contributor, verb='a fait un appel à contribution', action_object=instance, target=comment_annotation)
            if metacategory.triggers_notifications == MetaCategory.COLLECTION_ADMINS:
                pass
        
def notify_users_on_new_revision(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        if instance.author != instance.annotation.author:
            notify.send(instance.author, recipient=instance.annotation.author, verb='a proposé une révision sur votre annotation', action_object=instance, target=instance.annotation)
        
        
def notify_users_on_accepted_revision(sender, instance, **kwargs):
    from iconolab.models import AnnotationRevision
    if sender == AnnotationRevision:
        if instance.author != instance.annotation.author and instance.state in [AnnotationRevision.ACCEPTED, AnnotationRevision.STUDIED]:
            notify.send(instance.annotation.author, recipient=instance.author, verb='a étudié votre révision', action_object=instance, target=instance.annotation)
        

# Stats handlers connect
post_save.connect(increment_annotations_count)
post_save.connect(increment_stats_on_new_comments)
revision_created.connect(increment_stats_on_new_revision)
revision_accepted.connect(increment_accepted_revisions)
# Notifications handlers connect
comment_was_posted.connect(notify_users_on_new_comment)
revision_created.connect(notify_users_on_new_revision)
revision_accepted.connect(notify_users_on_accepted_revision)
        