from django.conf import settings
from django.contrib.sites.models import Site
from django.core.mail import send_mail
from django.core.urlresolvers import reverse

current_site = Site.objects.get_current()

class EmailManager():

    VERB_NEW_COMMENT = 'a écrit un commentaire sur votre annotation'
    VERB_NEW_REPLY = 'a répondu à votre commentaire'
    VERB_NEW_ANNOTATION = 'a proposé une révision sur votre annotation'
    VERB_ACCEPTED_REVISION = 'a étudié votre révision'
    VERB_REQUEST_FOR_CONTRIBUTION = 'a fait un appel à contribution'
    VERB_REQUEST_FOR_EXPERTISE = 'a fait un appel à expertise'

    def __message_content(self, verb):
        notifications_url = 'http://' + current_site.domain + reverse('user_notifications')

        message  = 'Un utilisateur ' + verb + '\n'
        message += 'Connectez-vous pour voir les notifications\n\n'
        message += notifications_url

        return message

    def __send_mail(self, recipient, verb):
        send_mail(
            'Un utilisateur ' + verb,
            self.__message_content(verb),
            settings.CONTACT_EMAIL,
            [recipient.email]
        )

    def new_comment(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_COMMENT)

    def new_reply(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_REPLY)

    def new_revision(self, recipient):
        self.__send_mail(recipient, self.VERB_NEW_ANNOTATION)

    def accepted_revision(self, recipient):
        self.__send_mail(recipient, self.VERB_ACCEPTED_REVISION)

    def request_for_contribution(self, recipient):
        self.__send_mail(recipient, self.VERB_REQUEST_FOR_CONTRIBUTION)

    def request_for_expertise(self, recipient):
        self.__send_mail(recipient, self.VERB_REQUEST_FOR_EXPERTISE)
