import datetime
from haystack import indexes
from iconolab.models import Annotation


class AnnotationIndex(indexes.SearchIndex, indexes.Indexable):

	##indexed field
	text = indexes.CharField(document=True, use_template=True)

	title = indexes.CharField(model_attr='current_revision__title')
	description = indexes.CharField(model_attr='current_revision__description')
	tags = indexes.MultiValueField()

	## tags
	def get_model(self):
		return Annotation

	def prepare_tags(self, annotation):
		return ["toto", "titi", "sesl"]


	def index_queryset(self, using=None):
		return self.get_model().objects.filter(created__lte=datetime.datetime.now()).distinct('current_revision_id');