import datetime
from haystack import indexes
from iconolab.models import Annotation, Image

class ImageIndex(indexes.SearchIndex, indexes.Indexable):
    text = indexes.CharField(document=True, use_template=True)

    collection = indexes.CharField(model_attr='collection')
    authors = indexes.CharField(model_attr="authors")
    school = indexes.CharField(model_attr="school")
    designation = indexes.CharField(model_attr="designation")
    datation = indexes.CharField(model_attr="datation")
    technics = indexes.CharField(model_attr="technics")
    measurements = indexes.CharField(model_attr="measurements")

    create_or_usage_location = indexes.CharField(model_attr="item__metadatas__create_or_usage_location")
    discovery_context = indexes.CharField(model_attr="item__metadatas__discovery_context")
    conservation_location = indexes.CharField(model_attr="item__metadatas__conservation_location")
    
    tags = indexes.MultiValueField(model_attr="tags")

    def get_model(self):
        return Image

    def index_queryset(self, using=None):
        return self.get_model().objects.filter(created__lte=datetime.datetime.now())


class AnnotationIndex(indexes.SearchIndex, indexes.Indexable):

    ##indexed field
    text = indexes.CharField(document=True, use_template=True)

    title = indexes.CharField(model_attr='current_revision__title')
    description = indexes.CharField(model_attr='current_revision__description')
    tags = indexes.MultiValueField(model_attr='tags')

    ## tags
    def get_model(self):
        return Annotation

    def index_queryset(self, using=None):
        return self.get_model().objects.filter(created__lte=datetime.datetime.now())