# How to start?

1. Make sure PIP is installed then install Django and others dependencies with 

```
pip install -r requirements.txt

```

2. Move to src/iconolab/static/js to install js dependencies.
Make sure your have installed nodejs then run the command bellow

```
npm install

```
3. To recreate the bundle file that lives in dist/

```
npm build

```

4. To add a new js module, you can add it to the js/components folder and then run

```
npm start
```

## ICONOLAB ##

### 1. Configuration and setup

### virtualenv

- Install pip
- Create a virtualenv for the project (using virtualenvwrapper is a good idea if possible). Python version is 3.5.1
- Run

	pip install -r requirements.txt


### node.js

- Make sure nodejs is installed
- cd into iconolab/src/iconolab/static/iconolab/js and run
	
	npm install

- To recreate the bundle file that lives in dist/

	npm build

- To add a new js module, you can add it to the js/components folder and then run
	
	npm start

### Django project setup

- Copy iconolab/src/settings/dev.py.tmpl into iconolab/src/settings/dev.py, adapt content to configuration
- cd into iconolab/src folder and run

    python manage.py migrate

to create database tables

- Run

    python manage.py createsuperuser
    
to create an admin user

- Run

    python manage.py loaddata dev_initial_data
    
to load the provided data fixture. This fixture will create at least one of each object used in the app. Details on the fixture data below.


### 2. Development server

- cd into the iconolab/src folder and run

	python manage.py runserver
	
By default, the app is accessible through http://127.0.0.1:8000/home


### 3. Fixture loaded data

* User: contributeur1, password: firstuser
* User: contributeur2, password: seconduser

* Collection (name): ingres
* Image (ref): 1234567890 # You will need to move napoleon.jpg into web/media/uploads in order for the app to load the image properly
* Annotation (guid): 34ae39ae-a9a2-4736-bc59-ba6f00e37f52

To access the loaded annotation, follow:

	/collections/ingres/images/1234567890/annotations/34ae39ae-a9a2-4736-bc59-ba6f00e37f52/detail
	/collections/ingres/images/1234567890/annotations/34ae39ae-a9a2-4736-bc59-ba6f00e37f52/edit
	
The annotation owner is contributeur1, if you try to edit it as another user, it will create the revision but will not publish it in the current state of the project.
	
