from django.shortcuts import HttpResponse, get_object_or_404, render, redirect
from iconolab.models import Annotation
from django.http import Http404
from django.contrib.auth.decorators import login_required
from .forms import AnnotationForm

@login_required
def index(request):
	print(request.user)
	return HttpResponse("<p>Home</p>");


def draw_fragment(request, pk):
	annotation = get_object_or_404(Annotation, pk=pk)
	return render(request, 'iconolab/fragment_draw.html', {'annotation': annotation})

def create_annotation(request):
	return render(request, 'iconolab/create_annotation.html')
	pass

def show_annotation(request, pk):
	annotation = get_object_or_404(Annotation, pk=pk)
	return render(request, 'iconolab/show_annotation.html', {'annotation': annotation}) 


# save annotation
# handle revision
def save_annotation(request):
	pass

def edit_annotation(request, pk):

	#enregistrer title, description, fragment:nmz
	annotation = get_object_or_404(Annotation, pk=pk)

	if request.method == 'POST':
		Annotation_form = AnnotationForm(request.POST, instance=annotation)
		Annotation_form = AnnotationForm()
		if Annotation_form.is_valid():

			#redirect to view
			pass
	else:
		Annotation_form = AnnotationForm(instance = annotation)

	return render(request, 'iconolab/edit_annotation.html', {'annotation': annotation, 'form': Annotation_form }) 
	