from django.shortcuts import render, HttpResponse
from pprint import pprint

from django.views.decorators.csrf import csrf_exempt
from rest_framework.renderers import JSONRenderer
from rest_framework.parsers import JSONParser
from iconolab.models import Annotation
from .serializers import AnnotationSerializer

class JSONResponse(HttpResponse):
	def __init__(self, data, **kwargs):
		content = JSONRenderer().render(data)
		kwargs['content_type'] = 'application/json'
		super(JSONResponse, self).__init__(content)


# Create your views here.

def index(r):
	return HttpResponse('<p>You better know ... </p>')

@csrf_exempt
def annotation_list(request):
	
	if request.method == 'GET':
		annotations = Annotation.objects.all()
		serializer = AnnotationSerializer(annotations, many=True)
		return JSONResponse(serializer.data)



def get(request, pk):
	if request.method == 'GET':
		
		try:
			annotation = Annotation.objects.get(pk=pk)
		except Annotation.DoesNotExist:
			return HttpResponse(status=404)

		serializer = AnnotationSerializer(annotation) 
		return JSONResponse(serializer.data)
