var path = require('path');
var webpack = require('webpack');

module.exports = {
	entry: './main.js',
	output: {
		path: path.join(__dirname,'dist'),
		filename: 'bundle.js'
	},
	module: {
		loaders: [
			{test: /\.css$/, loader: 'style!css'},
			{test: /\.html$/, loader: 'html'},
			{
            	test: require.resolve('snapsvg'),
                loader: 'imports-loader?this=>window,fix=>module.exports=0'
            },
		]
	},

	resolve: {
		extensions: ['', '.js', '.json', '.html'],
		modulesDirectories: ['node_modules', 'loaders']
	}
}