from django.contrib import admin

# Register your models here.
from iconolab.models import (Tag, Annotation, Collection, Image,
	Comment, CommentAttachement, MetaCategory, Activity, Notification)


class CommentAttachmentInline(admin.TabularInline):
	model = CommentAttachement
	extra = 1


class CommentAdmin(admin.ModelAdmin):
	inlines = [CommentAttachmentInline]


#reversion
admin.site.register(Image)
admin.site.register(Collection)
admin.site.register(Tag)
admin.site.register(Annotation)
admin.site.register(MetaCategory)
admin.site.register(Comment, CommentAdmin)
admin.site.register(Activity)
admin.site.register(Notification)