from rest_framework import serializers
from iconolab.models import Annotation


class AnnotationSerializer(serializers.ModelSerializer):
	tags = serializers.HyperlinkedRelatedField(many=True, read_only=True, view_name='get')
	class Meta:
		model = Annotation
		fields = ('id', 'title', 'description', 'fragment', 'tags')
		
	def create(self, validated_data):
		"""
		Create a new Annotation
		"""
		return Annotation.create(**validated_data)

	def update(self, instance, validated_data):
		instance.title = validated_data.get('title', instance.title)
		instance.description = validated_data.get('description', instance.description)
		instance.fragment = validated_data.get('fragment', instance.fragment)
		instance.save()
		return instance