from django import forms
from django.utils.translation import ugettext_lazy as _
from django_comments_xtd.forms import XtdCommentForm
from django.contrib.contenttypes.models import ContentType
from django.conf import settings
from django.utils.encoding import force_text
from django.utils import timezone
from iconolab.models import MetaCategory

class IconolabCommentForm(XtdCommentForm):
    metacategories = forms.ModelMultipleChoiceField(queryset=MetaCategory.objects.all(), required=False)
    email = forms.EmailField(required=False)
    
    def __init__(self, *args, **kwargs):
        super(IconolabCommentForm, self).__init__(*args, **kwargs)
        self.fields.pop('email')
    
    def get_comment_create_data(self):
        return dict(
            content_type=ContentType.objects.get_for_model(self.target_object),
            object_pk=force_text(self.target_object._get_pk_val()),
            user_name=self.cleaned_data["name"],
            user_email='',
            user_url=self.cleaned_data["url"],
            comment=self.cleaned_data["comment"],
            submit_date=timezone.now(),
            site_id=settings.SITE_ID,
            is_public=True,
            is_removed=False,
        )